<?php
/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* EmployeeExperience File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace Microsoft\Graph\Model;

/**
* EmployeeExperience class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class EmployeeExperience implements \JsonSerializable
{
    /**
    * The array of properties available
    * to the model
    *
    * @var array $_propDict
    */
    protected $_propDict;

    /**
    * Construct a new EmployeeExperience
    *
    * @param array $propDict A list of properties to set
    */
    function __construct($propDict = array())
    {
        if (!is_array($propDict)) {
           $propDict = array();
        }
        $this->_propDict = $propDict;
    }

    /**
    * Gets the property dictionary of the EmployeeExperience
    *
    * @return array The list of properties
    */
    public function getProperties()
    {
        return $this->_propDict;
    }


     /**
     * Gets the learningCourseActivities
     *
     * @return array|null The learningCourseActivities
     */
    public function getLearningCourseActivities()
    {
        if (array_key_exists("learningCourseActivities", $this->_propDict)) {
           return $this->_propDict["learningCourseActivities"];
        } else {
            return null;
        }
    }

    /**
    * Sets the learningCourseActivities
    *
    * @param LearningCourseActivity[] $val The learningCourseActivities
    *
    * @return EmployeeExperience
    */
    public function setLearningCourseActivities($val)
    {
        $this->_propDict["learningCourseActivities"] = $val;
        return $this;
    }


     /**
     * Gets the learningProviders
    * A collection of learning providers.
     *
     * @return array|null The learningProviders
     */
    public function getLearningProviders()
    {
        if (array_key_exists("learningProviders", $this->_propDict)) {
           return $this->_propDict["learningProviders"];
        } else {
            return null;
        }
    }

    /**
    * Sets the learningProviders
    * A collection of learning providers.
    *
    * @param LearningProvider[] $val The learningProviders
    *
    * @return EmployeeExperience
    */
    public function setLearningProviders($val)
    {
        $this->_propDict["learningProviders"] = $val;
        return $this;
    }

    /**
    * Gets the ODataType
    *
    * @return string|null The ODataType
    */
    public function getODataType()
    {
        if (array_key_exists('@odata.type', $this->_propDict)) {
            return $this->_propDict["@odata.type"];
        }
        return null;
    }

    /**
    * Sets the ODataType
    *
    * @param string $val The ODataType
    *
    * @return EmployeeExperience
    */
    public function setODataType($val)
    {
        $this->_propDict["@odata.type"] = $val;
        return $this;
    }

    /**
    * Serializes the object by property array
    * Manually serialize DateTime into RFC3339 format
    *
    * @return array The list of properties
    */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
        $serializableProperties = $this->getProperties();
        foreach ($serializableProperties as $property => $val) {
            if (is_a($val, "\DateTime")) {
                $serializableProperties[$property] = $val->format(\DateTime::RFC3339);
            } else if (is_a($val, "\Microsoft\Graph\Core\Enum")) {
                $serializableProperties[$property] = $val->value();
            } else if (is_a($val, "\Entity")) {
                $serializableProperties[$property] = $val->jsonSerialize();
            } else if (is_a($val, "\GuzzleHttp\Psr7\Stream")) {
                $serializableProperties[$property] = (string) $val;
            }
        }
        return $serializableProperties;
    }
}
