<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\ContainerAnalysis;

class ContaineranalysisGoogleDevtoolsCloudbuildV1SourceProvenance extends \Google\Model
{
  /**
   * @var ContaineranalysisGoogleDevtoolsCloudbuildV1FileHashes[]
   */
  public $fileHashes;
  protected $fileHashesType = ContaineranalysisGoogleDevtoolsCloudbuildV1FileHashes::class;
  protected $fileHashesDataType = 'map';
  /**
   * @var ContaineranalysisGoogleDevtoolsCloudbuildV1ConnectedRepository
   */
  public $resolvedConnectedRepository;
  protected $resolvedConnectedRepositoryType = ContaineranalysisGoogleDevtoolsCloudbuildV1ConnectedRepository::class;
  protected $resolvedConnectedRepositoryDataType = '';
  /**
   * @var ContaineranalysisGoogleDevtoolsCloudbuildV1GitSource
   */
  public $resolvedGitSource;
  protected $resolvedGitSourceType = ContaineranalysisGoogleDevtoolsCloudbuildV1GitSource::class;
  protected $resolvedGitSourceDataType = '';
  /**
   * @var ContaineranalysisGoogleDevtoolsCloudbuildV1RepoSource
   */
  public $resolvedRepoSource;
  protected $resolvedRepoSourceType = ContaineranalysisGoogleDevtoolsCloudbuildV1RepoSource::class;
  protected $resolvedRepoSourceDataType = '';
  /**
   * @var ContaineranalysisGoogleDevtoolsCloudbuildV1StorageSource
   */
  public $resolvedStorageSource;
  protected $resolvedStorageSourceType = ContaineranalysisGoogleDevtoolsCloudbuildV1StorageSource::class;
  protected $resolvedStorageSourceDataType = '';
  /**
   * @var ContaineranalysisGoogleDevtoolsCloudbuildV1StorageSourceManifest
   */
  public $resolvedStorageSourceManifest;
  protected $resolvedStorageSourceManifestType = ContaineranalysisGoogleDevtoolsCloudbuildV1StorageSourceManifest::class;
  protected $resolvedStorageSourceManifestDataType = '';

  /**
   * @param ContaineranalysisGoogleDevtoolsCloudbuildV1FileHashes[]
   */
  public function setFileHashes($fileHashes)
  {
    $this->fileHashes = $fileHashes;
  }
  /**
   * @return ContaineranalysisGoogleDevtoolsCloudbuildV1FileHashes[]
   */
  public function getFileHashes()
  {
    return $this->fileHashes;
  }
  /**
   * @param ContaineranalysisGoogleDevtoolsCloudbuildV1ConnectedRepository
   */
  public function setResolvedConnectedRepository(ContaineranalysisGoogleDevtoolsCloudbuildV1ConnectedRepository $resolvedConnectedRepository)
  {
    $this->resolvedConnectedRepository = $resolvedConnectedRepository;
  }
  /**
   * @return ContaineranalysisGoogleDevtoolsCloudbuildV1ConnectedRepository
   */
  public function getResolvedConnectedRepository()
  {
    return $this->resolvedConnectedRepository;
  }
  /**
   * @param ContaineranalysisGoogleDevtoolsCloudbuildV1GitSource
   */
  public function setResolvedGitSource(ContaineranalysisGoogleDevtoolsCloudbuildV1GitSource $resolvedGitSource)
  {
    $this->resolvedGitSource = $resolvedGitSource;
  }
  /**
   * @return ContaineranalysisGoogleDevtoolsCloudbuildV1GitSource
   */
  public function getResolvedGitSource()
  {
    return $this->resolvedGitSource;
  }
  /**
   * @param ContaineranalysisGoogleDevtoolsCloudbuildV1RepoSource
   */
  public function setResolvedRepoSource(ContaineranalysisGoogleDevtoolsCloudbuildV1RepoSource $resolvedRepoSource)
  {
    $this->resolvedRepoSource = $resolvedRepoSource;
  }
  /**
   * @return ContaineranalysisGoogleDevtoolsCloudbuildV1RepoSource
   */
  public function getResolvedRepoSource()
  {
    return $this->resolvedRepoSource;
  }
  /**
   * @param ContaineranalysisGoogleDevtoolsCloudbuildV1StorageSource
   */
  public function setResolvedStorageSource(ContaineranalysisGoogleDevtoolsCloudbuildV1StorageSource $resolvedStorageSource)
  {
    $this->resolvedStorageSource = $resolvedStorageSource;
  }
  /**
   * @return ContaineranalysisGoogleDevtoolsCloudbuildV1StorageSource
   */
  public function getResolvedStorageSource()
  {
    return $this->resolvedStorageSource;
  }
  /**
   * @param ContaineranalysisGoogleDevtoolsCloudbuildV1StorageSourceManifest
   */
  public function setResolvedStorageSourceManifest(ContaineranalysisGoogleDevtoolsCloudbuildV1StorageSourceManifest $resolvedStorageSourceManifest)
  {
    $this->resolvedStorageSourceManifest = $resolvedStorageSourceManifest;
  }
  /**
   * @return ContaineranalysisGoogleDevtoolsCloudbuildV1StorageSourceManifest
   */
  public function getResolvedStorageSourceManifest()
  {
    return $this->resolvedStorageSourceManifest;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ContaineranalysisGoogleDevtoolsCloudbuildV1SourceProvenance::class, 'Google_Service_ContainerAnalysis_ContaineranalysisGoogleDevtoolsCloudbuildV1SourceProvenance');
