<?php
/**
 * Invoice Ninja (https://invoiceninja.com).
 *
 * @link https://github.com/invoiceninja/invoiceninja source repository
 *
 * @copyright Copyright (c) 2023. Invoice Ninja LLC (https://invoiceninja.com)
 *
 * @license https://www.elastic.co/licensing/elastic-license
 */

namespace App\Import\Definitions;

class RecurringInvoiceMap
{
    public static function importable()
    {
        return [
            0 => 'invoice.number',
            1 => 'invoice.user_id',
            2 => 'invoice.amount',
            3 => 'invoice.balance',
            4 => 'client.name',
            5 => 'invoice.discount',
            6 => 'invoice.po_number',
            7 => 'invoice.next_send_date',
            8 => 'invoice.due_date',
            9 => 'invoice.terms',
            10 => 'invoice.status',
            11 => 'invoice.public_notes',
            12 => 'invoice.is_sent',
            13 => 'invoice.private_notes',
            14 => 'invoice.uses_inclusive_taxes',
            15 => 'invoice.tax_name1',
            16 => 'invoice.tax_rate1',
            17 => 'invoice.tax_name2',
            18 => 'invoice.tax_rate2',
            19 => 'invoice.tax_name3',
            20 => 'invoice.tax_rate3',
            21 => 'invoice.is_amount_discount',
            22 => 'invoice.footer',
            23 => 'invoice.partial',
            24 => 'invoice.partial_due_date',
            25 => 'invoice.custom_value1',
            26 => 'invoice.custom_value2',
            27 => 'invoice.custom_value3',
            28 => 'invoice.custom_value4',
            29 => 'invoice.custom_surcharge1',
            30 => 'invoice.custom_surcharge2',
            31 => 'invoice.custom_surcharge3',
            32 => 'invoice.custom_surcharge4',
            33 => 'invoice.exchange_rate',
            34 => 'invoice.frequency_id',
            35 => 'invoice.remaining_cycles',
            36 => 'invoice.auto_bill',
            37 => 'payment.date',
            38 => 'payment.amount',
            39 => 'payment.transaction_reference',
            40 => 'item.quantity',
            41 => 'item.cost',
            42 => 'item.product_key',
            43 => 'item.notes',
            44 => 'item.discount',
            45 => 'item.is_amount_discount',
            46 => 'item.tax_name1',
            47 => 'item.tax_rate1',
            48 => 'item.tax_name2',
            49 => 'item.tax_rate2',
            50 => 'item.tax_name3',
            51 => 'item.tax_rate3',
            52 => 'item.custom_value1',
            53 => 'item.custom_value2',
            54 => 'item.custom_value3',
            55 => 'item.custom_value4',
            56 => 'item.type_id',
            57 => 'client.email',
        ];
    }

    public static function import_keys()
    {
        return [
            0 => 'texts.invoice_number',
            1 => 'texts.user',
            2 => 'texts.amount',
            3 => 'texts.balance',
            4 => 'texts.client',
            5 => 'texts.discount',
            6 => 'texts.po_number',
            7 => 'texts.start_date',
            8 => 'texts.due_date',
            9 => 'texts.terms',
            10 => 'texts.status',
            11 => 'texts.public_notes',
            12 => 'texts.sent',
            13 => 'texts.private_notes',
            14 => 'texts.uses_inclusive_taxes',
            15 => 'texts.tax_name',
            16 => 'texts.tax_rate',
            17 => 'texts.tax_name',
            18 => 'texts.tax_rate',
            19 => 'texts.tax_name',
            20 => 'texts.tax_rate',
            21 => 'texts.is_amount_discount',
            22 => 'texts.footer',
            23 => 'texts.partial',
            24 => 'texts.partial_due_date',
            25 => 'texts.custom_value1',
            26 => 'texts.custom_value2',
            27 => 'texts.custom_value3',
            28 => 'texts.custom_value4',
            29 => 'texts.surcharge',
            30 => 'texts.surcharge',
            31 => 'texts.surcharge',
            32 => 'texts.surcharge',
            33 => 'texts.exchange_rate',
            34 => 'texts.frequency_id',
            35 => 'texts.remaining_cycles',
            36 => 'texts.auto_bill',
            37 => 'texts.payment_date',
            38 => 'texts.payment_amount',
            39 => 'texts.transaction_reference',
            40 => 'texts.quantity',
            41 => 'texts.cost',
            42 => 'texts.product_key',
            43 => 'texts.notes',
            44 => 'texts.discount',
            45 => 'texts.is_amount_discount',
            46 => 'texts.tax_name',
            47 => 'texts.tax_rate',
            48 => 'texts.tax_name',
            49 => 'texts.tax_rate',
            50 => 'texts.tax_name',
            51 => 'texts.tax_rate',
            52 => 'texts.custom_value',
            53 => 'texts.custom_value',
            54 => 'texts.custom_value',
            55 => 'texts.custom_value',
            56 => 'texts.type',
            57 => 'texts.email',
        ];
    }
}
