
# Inventory Adjustment

Represents a change in state or quantity of product inventory at a
particular time and location.

## Structure

`InventoryAdjustment`

## Fields

| Name | Type | Tags | Description | Getter | Setter |
|  --- | --- | --- | --- | --- | --- |
| `id` | `?string` | Optional | A unique ID generated by Square for the<br>`InventoryAdjustment`.<br>**Constraints**: *Maximum Length*: `100` | getId(): ?string | setId(?string id): void |
| `referenceId` | `?string` | Optional | An optional ID provided by the application to tie the<br>`InventoryAdjustment` to an external<br>system.<br>**Constraints**: *Maximum Length*: `255` | getReferenceId(): ?string | setReferenceId(?string referenceId): void |
| `fromState` | [`?string(InventoryState)`](../../doc/models/inventory-state.md) | Optional | Indicates the state of a tracked item quantity in the lifecycle of goods. | getFromState(): ?string | setFromState(?string fromState): void |
| `toState` | [`?string(InventoryState)`](../../doc/models/inventory-state.md) | Optional | Indicates the state of a tracked item quantity in the lifecycle of goods. | getToState(): ?string | setToState(?string toState): void |
| `locationId` | `?string` | Optional | The Square-generated ID of the [Location](entity:Location) where the related<br>quantity of items is being tracked.<br>**Constraints**: *Maximum Length*: `100` | getLocationId(): ?string | setLocationId(?string locationId): void |
| `catalogObjectId` | `?string` | Optional | The Square-generated ID of the<br>[CatalogObject](entity:CatalogObject) being tracked.<br>**Constraints**: *Maximum Length*: `100` | getCatalogObjectId(): ?string | setCatalogObjectId(?string catalogObjectId): void |
| `catalogObjectType` | `?string` | Optional | The [type](entity:CatalogObjectType) of the [CatalogObject](entity:CatalogObject) being tracked.<br><br>The Inventory API supports setting and reading the `"catalog_object_type": "ITEM_VARIATION"` field value.<br>In addition, it can also read the `"catalog_object_type": "ITEM"` field value that is set by the Square Restaurants app.<br>**Constraints**: *Maximum Length*: `14` | getCatalogObjectType(): ?string | setCatalogObjectType(?string catalogObjectType): void |
| `quantity` | `?string` | Optional | The number of items affected by the adjustment as a decimal string.<br>Can support up to 5 digits after the decimal point.<br>**Constraints**: *Maximum Length*: `26` | getQuantity(): ?string | setQuantity(?string quantity): void |
| `totalPriceMoney` | [`?Money`](../../doc/models/money.md) | Optional | Represents an amount of money. `Money` fields can be signed or unsigned.<br>Fields that do not explicitly define whether they are signed or unsigned are<br>considered unsigned and can only hold positive amounts. For signed fields, the<br>sign of the value indicates the purpose of the money transfer. See<br>[Working with Monetary Amounts](https://developer.squareup.com/docs/build-basics/working-with-monetary-amounts)<br>for more information. | getTotalPriceMoney(): ?Money | setTotalPriceMoney(?Money totalPriceMoney): void |
| `occurredAt` | `?string` | Optional | A client-generated RFC 3339-formatted timestamp that indicates when<br>the inventory adjustment took place. For inventory adjustment updates, the `occurred_at`<br>timestamp cannot be older than 24 hours or in the future relative to the<br>time of the request.<br>**Constraints**: *Maximum Length*: `34` | getOccurredAt(): ?string | setOccurredAt(?string occurredAt): void |
| `createdAt` | `?string` | Optional | An RFC 3339-formatted timestamp that indicates when the inventory adjustment is received.<br>**Constraints**: *Maximum Length*: `34` | getCreatedAt(): ?string | setCreatedAt(?string createdAt): void |
| `source` | [`?SourceApplication`](../../doc/models/source-application.md) | Optional | Represents information about the application used to generate a change. | getSource(): ?SourceApplication | setSource(?SourceApplication source): void |
| `employeeId` | `?string` | Optional | The Square-generated ID of the [Employee](entity:Employee) responsible for the<br>inventory adjustment.<br>**Constraints**: *Maximum Length*: `100` | getEmployeeId(): ?string | setEmployeeId(?string employeeId): void |
| `teamMemberId` | `?string` | Optional | The Square-generated ID of the [Team Member](entity:TeamMember) responsible for the<br>inventory adjustment.<br>**Constraints**: *Maximum Length*: `100` | getTeamMemberId(): ?string | setTeamMemberId(?string teamMemberId): void |
| `transactionId` | `?string` | Optional | The Square-generated ID of the [Transaction](entity:Transaction) that<br>caused the adjustment. Only relevant for payment-related state<br>transitions.<br>**Constraints**: *Maximum Length*: `255` | getTransactionId(): ?string | setTransactionId(?string transactionId): void |
| `refundId` | `?string` | Optional | The Square-generated ID of the [Refund](entity:Refund) that<br>caused the adjustment. Only relevant for refund-related state<br>transitions.<br>**Constraints**: *Maximum Length*: `255` | getRefundId(): ?string | setRefundId(?string refundId): void |
| `purchaseOrderId` | `?string` | Optional | The Square-generated ID of the purchase order that caused the<br>adjustment. Only relevant for state transitions from the Square for Retail<br>app.<br>**Constraints**: *Maximum Length*: `100` | getPurchaseOrderId(): ?string | setPurchaseOrderId(?string purchaseOrderId): void |
| `goodsReceiptId` | `?string` | Optional | The Square-generated ID of the goods receipt that caused the<br>adjustment. Only relevant for state transitions from the Square for Retail<br>app.<br>**Constraints**: *Maximum Length*: `100` | getGoodsReceiptId(): ?string | setGoodsReceiptId(?string goodsReceiptId): void |
| `adjustmentGroup` | [`?InventoryAdjustmentGroup`](../../doc/models/inventory-adjustment-group.md) | Optional | - | getAdjustmentGroup(): ?InventoryAdjustmentGroup | setAdjustmentGroup(?InventoryAdjustmentGroup adjustmentGroup): void |

## Example (as JSON)

```json
{
  "id": "id0",
  "reference_id": "reference_id2",
  "from_state": "RESERVED_FOR_SALE",
  "to_state": "SUPPORTED_BY_NEWER_VERSION",
  "location_id": "location_id4"
}
```

