<?php

/**
 * This file is a part of horstoeko/zugferd.
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace horstoeko\zugferd\codelists;

/**
 * Class representing the Text subject code qualifiers
 *
 * @category Zugferd
 * @package  Zugferd
 * @author   D. Erling <horstoeko@erling.com.de>
 * @license  https://opensource.org/licenses/MIT MIT
 * @link     https://github.com/horstoeko/zugferd
 */
class ZugferdTextSubjectCodeQualifiers
{
    /**
     * Goods item description
     */
    const UNTDID_4451_AAA = 'AAA';

    /**
     * Payment term
     */
    const UNTDID_4451_AAB = 'AAB';

    /**
     * Dangerous goods additional information
     */
    const UNTDID_4451_AAC = 'AAC';

    /**
     * Dangerous goods technical name
     */
    const UNTDID_4451_AAD = 'AAD';

    /**
     * Acknowledgement description
     */
    const UNTDID_4451_AAE = 'AAE';

    /**
     * Rate additional information
     */
    const UNTDID_4451_AAF = 'AAF';

    /**
     * Party instructions
     */
    const UNTDID_4451_AAG = 'AAG';

    /**
     * General information
     */
    const UNTDID_4451_AAI = 'AAI';

    /**
     * Additional conditions of sale/purchase
     */
    const UNTDID_4451_AAJ = 'AAJ';

    /**
     * Price conditions
     */
    const UNTDID_4451_AAK = 'AAK';

    /**
     * Goods dimensions in characters
     */
    const UNTDID_4451_AAL = 'AAL';

    /**
     * Equipment re-usage restrictions
     */
    const UNTDID_4451_AAM = 'AAM';

    /**
     * Handling restriction
     */
    const UNTDID_4451_AAN = 'AAN';

    /**
     * Error description (free text)
     */
    const UNTDID_4451_AAO = 'AAO';

    /**
     * Response (free text)
     */
    const UNTDID_4451_AAP = 'AAP';

    /**
     * Package content's description
     */
    const UNTDID_4451_AAQ = 'AAQ';

    /**
     * Terms of delivery
     */
    const UNTDID_4451_AAR = 'AAR';

    /**
     * Bill of lading remarks
     */
    const UNTDID_4451_AAS = 'AAS';

    /**
     * Mode of settlement information
     */
    const UNTDID_4451_AAT = 'AAT';

    /**
     * Consignment invoice information
     */
    const UNTDID_4451_AAU = 'AAU';

    /**
     * Clearance invoice information
     */
    const UNTDID_4451_AAV = 'AAV';

    /**
     * Letter of credit information
     */
    const UNTDID_4451_AAW = 'AAW';

    /**
     * License information
     */
    const UNTDID_4451_AAX = 'AAX';

    /**
     * Certification statements
     */
    const UNTDID_4451_AAY = 'AAY';

    /**
     * Additional export information
     */
    const UNTDID_4451_AAZ = 'AAZ';

    /**
     * Tariff statements
     */
    const UNTDID_4451_ABA = 'ABA';

    /**
     * Medical history
     */
    const UNTDID_4451_ABB = 'ABB';

    /**
     * Conditions of sale or purchase
     */
    const UNTDID_4451_ABC = 'ABC';

    /**
     * Contract document type
     */
    const UNTDID_4451_ABD = 'ABD';

    /**
     * Additional terms and/or conditions (documentary credit)
     */
    const UNTDID_4451_ABE = 'ABE';

    /**
     * Instructions or information about standby documentary
     */
    const UNTDID_4451_ABF = 'ABF';

    /**
     * Instructions or information about partial shipment(s)
     */
    const UNTDID_4451_ABG = 'ABG';

    /**
     * Instructions or information about transhipment(s)
     */
    const UNTDID_4451_ABH = 'ABH';

    /**
     * Additional handling instructions documentary credit
     */
    const UNTDID_4451_ABI = 'ABI';

    /**
     * Domestic routing information
     */
    const UNTDID_4451_ABJ = 'ABJ';

    /**
     * Chargeable category of equipment
     */
    const UNTDID_4451_ABK = 'ABK';

    /**
     * Government information
     */
    const UNTDID_4451_ABL = 'ABL';

    /**
     * Onward routing information
     */
    const UNTDID_4451_ABM = 'ABM';

    /**
     * Accounting information
     */
    const UNTDID_4451_ABN = 'ABN';

    /**
     * Discrepancy information
     */
    const UNTDID_4451_ABO = 'ABO';

    /**
     * Confirmation instructions
     */
    const UNTDID_4451_ABP = 'ABP';

    /**
     * Method of issuance
     */
    const UNTDID_4451_ABQ = 'ABQ';

    /**
     * Documents delivery instructions
     */
    const UNTDID_4451_ABR = 'ABR';

    /**
     * Additional conditions
     */
    const UNTDID_4451_ABS = 'ABS';

    /**
     * Information/instructions about additional amounts covered
     */
    const UNTDID_4451_ABT = 'ABT';

    /**
     * Deferred payment termed additional
     */
    const UNTDID_4451_ABU = 'ABU';

    /**
     * Acceptance terms additional
     */
    const UNTDID_4451_ABV = 'ABV';

    /**
     * Negotiation terms additional
     */
    const UNTDID_4451_ABW = 'ABW';

    /**
     * Document name and documentary requirements
     */
    const UNTDID_4451_ABX = 'ABX';

    /**
     * Instructions/information about revolving documentary credit
     */
    const UNTDID_4451_ABZ = 'ABZ';

    /**
     * Documentary requirements
     */
    const UNTDID_4451_ACA = 'ACA';

    /**
     * Additional information
     */
    const UNTDID_4451_ACB = 'ACB';

    /**
     * Factor assignment clause
     */
    const UNTDID_4451_ACC = 'ACC';

    /**
     * Reason
     */
    const UNTDID_4451_ACD = 'ACD';

    /**
     * Dispute
     */
    const UNTDID_4451_ACE = 'ACE';

    /**
     * Additional attribute information
     */
    const UNTDID_4451_ACF = 'ACF';

    /**
     * Absence declaration
     */
    const UNTDID_4451_ACG = 'ACG';

    /**
     * Aggregation statement
     */
    const UNTDID_4451_ACH = 'ACH';

    /**
     * Compilation statement
     */
    const UNTDID_4451_ACI = 'ACI';

    /**
     * Definitional exception
     */
    const UNTDID_4451_ACJ = 'ACJ';

    /**
     * Privacy statement
     */
    const UNTDID_4451_ACK = 'ACK';

    /**
     * Quality statement
     */
    const UNTDID_4451_ACL = 'ACL';

    /**
     * Statistical description
     */
    const UNTDID_4451_ACM = 'ACM';

    /**
     * Statistical definition
     */
    const UNTDID_4451_ACN = 'ACN';

    /**
     * Statistical name
     */
    const UNTDID_4451_ACO = 'ACO';

    /**
     * Statistical title
     */
    const UNTDID_4451_ACP = 'ACP';

    /**
     * Off-dimension information
     */
    const UNTDID_4451_ACQ = 'ACQ';

    /**
     * Unexpected stops information
     */
    const UNTDID_4451_ACR = 'ACR';

    /**
     * Principles
     */
    const UNTDID_4451_ACS = 'ACS';

    /**
     * Terms and definition
     */
    const UNTDID_4451_ACT = 'ACT';

    /**
     * Segment name
     */
    const UNTDID_4451_ACU = 'ACU';

    /**
     * Simple data element name
     */
    const UNTDID_4451_ACV = 'ACV';

    /**
     * Scope
     */
    const UNTDID_4451_ACW = 'ACW';

    /**
     * Message type name
     */
    const UNTDID_4451_ACX = 'ACX';

    /**
     * Introduction
     */
    const UNTDID_4451_ACY = 'ACY';

    /**
     * Glossary
     */
    const UNTDID_4451_ACZ = 'ACZ';

    /**
     * Functional definition
     */
    const UNTDID_4451_ADA = 'ADA';

    /**
     * Examples
     */
    const UNTDID_4451_ADB = 'ADB';

    /**
     * Cover page
     */
    const UNTDID_4451_ADC = 'ADC';

    /**
     * Dependency (syntax) notes
     */
    const UNTDID_4451_ADD = 'ADD';

    /**
     * Code value name
     */
    const UNTDID_4451_ADE = 'ADE';

    /**
     * Code list name
     */
    const UNTDID_4451_ADF = 'ADF';

    /**
     * Clarification of usage
     */
    const UNTDID_4451_ADG = 'ADG';

    /**
     * Composite data element name
     */
    const UNTDID_4451_ADH = 'ADH';

    /**
     * Field of application
     */
    const UNTDID_4451_ADI = 'ADI';

    /**
     * Type of assets and liabilities
     */
    const UNTDID_4451_ADJ = 'ADJ';

    /**
     * Promotion information
     */
    const UNTDID_4451_ADK = 'ADK';

    /**
     * Meter condition
     */
    const UNTDID_4451_ADL = 'ADL';

    /**
     * Meter reading information
     */
    const UNTDID_4451_ADM = 'ADM';

    /**
     * Type of transaction reason
     */
    const UNTDID_4451_ADN = 'ADN';

    /**
     * Type of survey question
     */
    const UNTDID_4451_ADO = 'ADO';

    /**
     * Carrier's agent counter information
     */
    const UNTDID_4451_ADP = 'ADP';

    /**
     * Description of work item on equipment
     */
    const UNTDID_4451_ADQ = 'ADQ';

    /**
     * Message definition
     */
    const UNTDID_4451_ADR = 'ADR';

    /**
     * Booked item information
     */
    const UNTDID_4451_ADS = 'ADS';

    /**
     * Source of document
     */
    const UNTDID_4451_ADT = 'ADT';

    /**
     * Note
     */
    const UNTDID_4451_ADU = 'ADU';

    /**
     * Fixed part of segment clarification text
     */
    const UNTDID_4451_ADV = 'ADV';

    /**
     * Characteristics of goods
     */
    const UNTDID_4451_ADW = 'ADW';

    /**
     * Additional discharge instructions
     */
    const UNTDID_4451_ADX = 'ADX';

    /**
     * Container stripping instructions
     */
    const UNTDID_4451_ADY = 'ADY';

    /**
     * CSC (Container Safety Convention) plate information
     */
    const UNTDID_4451_ADZ = 'ADZ';

    /**
     * Cargo remarks
     */
    const UNTDID_4451_AEA = 'AEA';

    /**
     * Temperature control instructions
     */
    const UNTDID_4451_AEB = 'AEB';

    /**
     * Text refers to expected data
     */
    const UNTDID_4451_AEC = 'AEC';

    /**
     * Text refers to received data
     */
    const UNTDID_4451_AED = 'AED';

    /**
     * Section clarification text
     */
    const UNTDID_4451_AEE = 'AEE';

    /**
     * Information to the beneficiary
     */
    const UNTDID_4451_AEF = 'AEF';

    /**
     * Information to the applicant
     */
    const UNTDID_4451_AEG = 'AEG';

    /**
     * Instructions to the beneficiary
     */
    const UNTDID_4451_AEH = 'AEH';

    /**
     * Instructions to the applicant
     */
    const UNTDID_4451_AEI = 'AEI';

    /**
     * Controlled atmosphere
     */
    const UNTDID_4451_AEJ = 'AEJ';

    /**
     * Take off annotation
     */
    const UNTDID_4451_AEK = 'AEK';

    /**
     * Price variation narrative
     */
    const UNTDID_4451_AEL = 'AEL';

    /**
     * Documentary credit amendment instructions
     */
    const UNTDID_4451_AEM = 'AEM';

    /**
     * Standard method narrative
     */
    const UNTDID_4451_AEN = 'AEN';

    /**
     * Project narrative
     */
    const UNTDID_4451_AEO = 'AEO';

    /**
     * Radioactive goods, additional information
     */
    const UNTDID_4451_AEP = 'AEP';

    /**
     * Bank-to-bank information
     */
    const UNTDID_4451_AEQ = 'AEQ';

    /**
     * Reimbursement instructions
     */
    const UNTDID_4451_AER = 'AER';

    /**
     * Reason for amending a message
     */
    const UNTDID_4451_AES = 'AES';

    /**
     * Instructions to the paying and/or accepting and/or
     */
    const UNTDID_4451_AET = 'AET';

    /**
     * Interest instructions
     */
    const UNTDID_4451_AEU = 'AEU';

    /**
     * Agent commission
     */
    const UNTDID_4451_AEV = 'AEV';

    /**
     * Remitting bank instructions
     */
    const UNTDID_4451_AEW = 'AEW';

    /**
     * Instructions to the collecting bank
     */
    const UNTDID_4451_AEX = 'AEX';

    /**
     * Collection amount instructions
     */
    const UNTDID_4451_AEY = 'AEY';

    /**
     * Internal auditing information
     */
    const UNTDID_4451_AEZ = 'AEZ';

    /**
     * Constraint
     */
    const UNTDID_4451_AFA = 'AFA';

    /**
     * Comment
     */
    const UNTDID_4451_AFB = 'AFB';

    /**
     * Semantic note
     */
    const UNTDID_4451_AFC = 'AFC';

    /**
     * Help text
     */
    const UNTDID_4451_AFD = 'AFD';

    /**
     * Legend
     */
    const UNTDID_4451_AFE = 'AFE';

    /**
     * Batch code structure
     */
    const UNTDID_4451_AFF = 'AFF';

    /**
     * Product application
     */
    const UNTDID_4451_AFG = 'AFG';

    /**
     * Customer complaint
     */
    const UNTDID_4451_AFH = 'AFH';

    /**
     * Probable cause of fault
     */
    const UNTDID_4451_AFI = 'AFI';

    /**
     * Defect description
     */
    const UNTDID_4451_AFJ = 'AFJ';

    /**
     * Repair description
     */
    const UNTDID_4451_AFK = 'AFK';

    /**
     * Review comments
     */
    const UNTDID_4451_AFL = 'AFL';

    /**
     * Title
     */
    const UNTDID_4451_AFM = 'AFM';

    /**
     * Description of amount
     */
    const UNTDID_4451_AFN = 'AFN';

    /**
     * Responsibilities
     */
    const UNTDID_4451_AFO = 'AFO';

    /**
     * Supplier
     */
    const UNTDID_4451_AFP = 'AFP';

    /**
     * Purchase region
     */
    const UNTDID_4451_AFQ = 'AFQ';

    /**
     * Affiliation
     */
    const UNTDID_4451_AFR = 'AFR';

    /**
     * Borrower
     */
    const UNTDID_4451_AFS = 'AFS';

    /**
     * Line of business
     */
    const UNTDID_4451_AFT = 'AFT';

    /**
     * Financial institution
     */
    const UNTDID_4451_AFU = 'AFU';

    /**
     * Business founder
     */
    const UNTDID_4451_AFV = 'AFV';

    /**
     * Business history
     */
    const UNTDID_4451_AFW = 'AFW';

    /**
     * Banking arrangements
     */
    const UNTDID_4451_AFX = 'AFX';

    /**
     * Business origin
     */
    const UNTDID_4451_AFY = 'AFY';

    /**
     * Brand names' description
     */
    const UNTDID_4451_AFZ = 'AFZ';

    /**
     * Business financing details
     */
    const UNTDID_4451_AGA = 'AGA';

    /**
     * Competition
     */
    const UNTDID_4451_AGB = 'AGB';

    /**
     * Construction process details
     */
    const UNTDID_4451_AGC = 'AGC';

    /**
     * Construction specialty
     */
    const UNTDID_4451_AGD = 'AGD';

    /**
     * Contract information
     */
    const UNTDID_4451_AGE = 'AGE';

    /**
     * Corporate filing
     */
    const UNTDID_4451_AGF = 'AGF';

    /**
     * Customer information
     */
    const UNTDID_4451_AGG = 'AGG';

    /**
     * Copyright notice
     */
    const UNTDID_4451_AGH = 'AGH';

    /**
     * Contingent debt
     */
    const UNTDID_4451_AGI = 'AGI';

    /**
     * Conviction details
     */
    const UNTDID_4451_AGJ = 'AGJ';

    /**
     * Equipment
     */
    const UNTDID_4451_AGK = 'AGK';

    /**
     * Workforce description
     */
    const UNTDID_4451_AGL = 'AGL';

    /**
     * Exemption
     */
    const UNTDID_4451_AGM = 'AGM';

    /**
     * Future plans
     */
    const UNTDID_4451_AGN = 'AGN';

    /**
     * Interviewee conversation information
     */
    const UNTDID_4451_AGO = 'AGO';

    /**
     * Intangible asset
     */
    const UNTDID_4451_AGP = 'AGP';

    /**
     * Inventory
     */
    const UNTDID_4451_AGQ = 'AGQ';

    /**
     * Investment
     */
    const UNTDID_4451_AGR = 'AGR';

    /**
     * Intercompany relations information
     */
    const UNTDID_4451_AGS = 'AGS';

    /**
     * Joint venture
     */
    const UNTDID_4451_AGT = 'AGT';

    /**
     * Loan
     */
    const UNTDID_4451_AGU = 'AGU';

    /**
     * Long term debt
     */
    const UNTDID_4451_AGV = 'AGV';

    /**
     * Location
     */
    const UNTDID_4451_AGW = 'AGW';

    /**
     * Current legal structure
     */
    const UNTDID_4451_AGX = 'AGX';

    /**
     * Marital contract
     */
    const UNTDID_4451_AGY = 'AGY';

    /**
     * Marketing activities
     */
    const UNTDID_4451_AGZ = 'AGZ';

    /**
     * Merger
     */
    const UNTDID_4451_AHA = 'AHA';

    /**
     * Marketable securities
     */
    const UNTDID_4451_AHB = 'AHB';

    /**
     * Business debt
     */
    const UNTDID_4451_AHC = 'AHC';

    /**
     * Original legal structure
     */
    const UNTDID_4451_AHD = 'AHD';

    /**
     * Employee sharing arrangements
     */
    const UNTDID_4451_AHE = 'AHE';

    /**
     * Organization details
     */
    const UNTDID_4451_AHF = 'AHF';

    /**
     * Public record details
     */
    const UNTDID_4451_AHG = 'AHG';

    /**
     * Price range
     */
    const UNTDID_4451_AHH = 'AHH';

    /**
     * Qualifications
     */
    const UNTDID_4451_AHI = 'AHI';

    /**
     * Registered activity
     */
    const UNTDID_4451_AHJ = 'AHJ';

    /**
     * Criminal sentence
     */
    const UNTDID_4451_AHK = 'AHK';

    /**
     * Sales method
     */
    const UNTDID_4451_AHL = 'AHL';

    /**
     * Educational institution information
     */
    const UNTDID_4451_AHM = 'AHM';

    /**
     * Status details
     */
    const UNTDID_4451_AHN = 'AHN';

    /**
     * Sales
     */
    const UNTDID_4451_AHO = 'AHO';

    /**
     * Spouse information
     */
    const UNTDID_4451_AHP = 'AHP';

    /**
     * Educational degree information
     */
    const UNTDID_4451_AHQ = 'AHQ';

    /**
     * Shareholding information
     */
    const UNTDID_4451_AHR = 'AHR';

    /**
     * Sales territory
     */
    const UNTDID_4451_AHS = 'AHS';

    /**
     * Accountant's comments
     */
    const UNTDID_4451_AHT = 'AHT';

    /**
     * Exemption law location
     */
    const UNTDID_4451_AHU = 'AHU';

    /**
     * Share classifications
     */
    const UNTDID_4451_AHV = 'AHV';

    /**
     * Forecast
     */
    const UNTDID_4451_AHW = 'AHW';

    /**
     * Event location
     */
    const UNTDID_4451_AHX = 'AHX';

    /**
     * Facility occupancy
     */
    const UNTDID_4451_AHY = 'AHY';

    /**
     * Import and export details
     */
    const UNTDID_4451_AHZ = 'AHZ';

    /**
     * Additional facility information
     */
    const UNTDID_4451_AIA = 'AIA';

    /**
     * Inventory value
     */
    const UNTDID_4451_AIB = 'AIB';

    /**
     * Education
     */
    const UNTDID_4451_AIC = 'AIC';

    /**
     * Event
     */
    const UNTDID_4451_AID = 'AID';

    /**
     * Agent
     */
    const UNTDID_4451_AIE = 'AIE';

    /**
     * Domestically agreed financial statement details
     */
    const UNTDID_4451_AIF = 'AIF';

    /**
     * Other current asset description
     */
    const UNTDID_4451_AIG = 'AIG';

    /**
     * Other current liability description
     */
    const UNTDID_4451_AIH = 'AIH';

    /**
     * Former business activity
     */
    const UNTDID_4451_AII = 'AII';

    /**
     * Trade name use
     */
    const UNTDID_4451_AIJ = 'AIJ';

    /**
     * Signing authority
     */
    const UNTDID_4451_AIK = 'AIK';

    /**
     * Guarantee
     */
    const UNTDID_4451_AIL = 'AIL';

    /**
     * Holding company operation
     */
    const UNTDID_4451_AIM = 'AIM';

    /**
     * Consignment routing
     */
    const UNTDID_4451_AIN = 'AIN';

    /**
     * Letter of protest
     */
    const UNTDID_4451_AIO = 'AIO';

    /**
     * Question
     */
    const UNTDID_4451_AIP = 'AIP';

    /**
     * Party information
     */
    const UNTDID_4451_AIQ = 'AIQ';

    /**
     * Area boundaries description
     */
    const UNTDID_4451_AIR = 'AIR';

    /**
     * Advertisement information
     */
    const UNTDID_4451_AIS = 'AIS';

    /**
     * Financial statement details
     */
    const UNTDID_4451_AIT = 'AIT';

    /**
     * Access instructions
     */
    const UNTDID_4451_AIU = 'AIU';

    /**
     * Liquidity
     */
    const UNTDID_4451_AIV = 'AIV';

    /**
     * Credit line
     */
    const UNTDID_4451_AIW = 'AIW';

    /**
     * Warranty terms
     */
    const UNTDID_4451_AIX = 'AIX';

    /**
     * Division description
     */
    const UNTDID_4451_AIY = 'AIY';

    /**
     * Reporting instruction
     */
    const UNTDID_4451_AIZ = 'AIZ';

    /**
     * Examination result
     */
    const UNTDID_4451_AJA = 'AJA';

    /**
     * Laboratory result
     */
    const UNTDID_4451_AJB = 'AJB';

    /**
     * Allowance/charge information
     */
    const UNTDID_4451_ALC = 'ALC';

    /**
     * X-ray result
     */
    const UNTDID_4451_ALD = 'ALD';

    /**
     * Pathology result
     */
    const UNTDID_4451_ALE = 'ALE';

    /**
     * Intervention description
     */
    const UNTDID_4451_ALF = 'ALF';

    /**
     * Summary of admittance
     */
    const UNTDID_4451_ALG = 'ALG';

    /**
     * Medical treatment course detail
     */
    const UNTDID_4451_ALH = 'ALH';

    /**
     * Prognosis
     */
    const UNTDID_4451_ALI = 'ALI';

    /**
     * Instruction to patient
     */
    const UNTDID_4451_ALJ = 'ALJ';

    /**
     * Instruction to physician
     */
    const UNTDID_4451_ALK = 'ALK';

    /**
     * All documents
     */
    const UNTDID_4451_ALL = 'ALL';

    /**
     * Medicine treatment
     */
    const UNTDID_4451_ALM = 'ALM';

    /**
     * Medicine dosage and administration
     */
    const UNTDID_4451_ALN = 'ALN';

    /**
     * Availability of patient
     */
    const UNTDID_4451_ALO = 'ALO';

    /**
     * Reason for service request
     */
    const UNTDID_4451_ALP = 'ALP';

    /**
     * Purpose of service
     */
    const UNTDID_4451_ALQ = 'ALQ';

    /**
     * Arrival conditions
     */
    const UNTDID_4451_ARR = 'ARR';

    /**
     * Service requester's comment
     */
    const UNTDID_4451_ARS = 'ARS';

    /**
     * Authentication
     */
    const UNTDID_4451_AUT = 'AUT';

    /**
     * Requested location description
     */
    const UNTDID_4451_AUU = 'AUU';

    /**
     * Medicine administration condition
     */
    const UNTDID_4451_AUV = 'AUV';

    /**
     * Patient information
     */
    const UNTDID_4451_AUW = 'AUW';

    /**
     * Precautionary measure
     */
    const UNTDID_4451_AUX = 'AUX';

    /**
     * Service characteristic
     */
    const UNTDID_4451_AUY = 'AUY';

    /**
     * Planned event comment
     */
    const UNTDID_4451_AUZ = 'AUZ';

    /**
     * Expected delay comment
     */
    const UNTDID_4451_AVA = 'AVA';

    /**
     * Transport requirements comment
     */
    const UNTDID_4451_AVB = 'AVB';

    /**
     * Temporary approval condition
     */
    const UNTDID_4451_AVC = 'AVC';

    /**
     * Customs Valuation Information
     */
    const UNTDID_4451_AVD = 'AVD';

    /**
     * Value Added Tax (VAT) margin scheme
     */
    const UNTDID_4451_AVE = 'AVE';

    /**
     * Maritime Declaration of Health
     */
    const UNTDID_4451_AVF = 'AVF';

    /**
     * Passenger baggage information
     */
    const UNTDID_4451_BAG = 'BAG';

    /**
     * Maritime Declaration of Health
     */
    const UNTDID_4451_BAH = 'BAH';

    /**
     * Additional product information address
     */
    const UNTDID_4451_BAI = 'BAI';

    /**
     * Information to be printed on despatch advice
     */
    const UNTDID_4451_BAJ = 'BAJ';

    /**
     * Missing goods remarks
     */
    const UNTDID_4451_BAK = 'BAK';

    /**
     * Non-acceptance information
     */
    const UNTDID_4451_BAL = 'BAL';

    /**
     * Returns information
     */
    const UNTDID_4451_BAM = 'BAM';

    /**
     * Sub-line item information
     */
    const UNTDID_4451_BAN = 'BAN';

    /**
     * Test information
     */
    const UNTDID_4451_BAO = 'BAO';

    /**
     * External link
     */
    const UNTDID_4451_BAP = 'BAP';

    /**
     * VAT exemption reason
     */
    const UNTDID_4451_BAQ = 'BAQ';

    /**
     * Processing Instructions
     */
    const UNTDID_4451_BAR = 'BAR';

    /**
     * Relay Instructions
     */
    const UNTDID_4451_BAS = 'BAS';

    /**
     * Transport contract document clause
     */
    const UNTDID_4451_BLC = 'BLC';

    /**
     * Instruction to prepare the patient
     */
    const UNTDID_4451_BLD = 'BLD';

    /**
     * Medicine treatment comment
     */
    const UNTDID_4451_BLE = 'BLE';

    /**
     * Examination result comment
     */
    const UNTDID_4451_BLF = 'BLF';

    /**
     * Service request comment
     */
    const UNTDID_4451_BLG = 'BLG';

    /**
     * Prescription reason
     */
    const UNTDID_4451_BLH = 'BLH';

    /**
     * Prescription comment
     */
    const UNTDID_4451_BLI = 'BLI';

    /**
     * Clinical investigation comment
     */
    const UNTDID_4451_BLJ = 'BLJ';

    /**
     * Medicinal specification comment
     */
    const UNTDID_4451_BLK = 'BLK';

    /**
     * Economic contribution comment
     */
    const UNTDID_4451_BLL = 'BLL';

    /**
     * Status of a plan
     */
    const UNTDID_4451_BLM = 'BLM';

    /**
     * Random sample test information
     */
    const UNTDID_4451_BLN = 'BLN';

    /**
     * Period of time
     */
    const UNTDID_4451_BLO = 'BLO';

    /**
     * Legislation
     */
    const UNTDID_4451_BLP = 'BLP';

    /**
     * Security measures requested
     */
    const UNTDID_4451_BLQ = 'BLQ';

    /**
     * Transport contract document remark
     */
    const UNTDID_4451_BLR = 'BLR';

    /**
     * Previous port of call security information
     */
    const UNTDID_4451_BLS = 'BLS';

    /**
     * Security information
     */
    const UNTDID_4451_BLT = 'BLT';

    /**
     * Waste information
     */
    const UNTDID_4451_BLU = 'BLU';

    /**
     * B2C marketing information, short description
     */
    const UNTDID_4451_BLV = 'BLV';

    /**
     * B2B marketing information, long description
     */
    const UNTDID_4451_BLW = 'BLW';

    /**
     * B2C marketing information, long description
     */
    const UNTDID_4451_BLX = 'BLX';

    /**
     * Product ingredients
     */
    const UNTDID_4451_BLY = 'BLY';

    /**
     * Location short name
     */
    const UNTDID_4451_BLZ = 'BLZ';

    /**
     * Packaging material information
     */
    const UNTDID_4451_BMA = 'BMA';

    /**
     * Filler material information
     */
    const UNTDID_4451_BMB = 'BMB';

    /**
     * Ship-to-ship activity information
     */
    const UNTDID_4451_BMC = 'BMC';

    /**
     * Package material description
     */
    const UNTDID_4451_BMD = 'BMD';

    /**
     * Consumer level package marking
     */
    const UNTDID_4451_BME = 'BME';

    /**
     * Customs clearance instructions
     */
    const UNTDID_4451_CCI = 'CCI';

    /**
     * Customs clearance instructions export
     */
    const UNTDID_4451_CEX = 'CEX';

    /**
     * Change information
     */
    const UNTDID_4451_CHG = 'CHG';

    /**
     * Customs clearance instruction import
     */
    const UNTDID_4451_CIP = 'CIP';

    /**
     * Clearance place requested
     */
    const UNTDID_4451_CLP = 'CLP';

    /**
     * Loading remarks
     */
    const UNTDID_4451_CLR = 'CLR';

    /**
     * Order information
     */
    const UNTDID_4451_COI = 'COI';

    /**
     * Customer remarks
     */
    const UNTDID_4451_CUR = 'CUR';

    /**
     * Customs declaration information
     */
    const UNTDID_4451_CUS = 'CUS';

    /**
     * Damage remarks
     */
    const UNTDID_4451_DAR = 'DAR';

    /**
     * Document issuer declaration
     */
    const UNTDID_4451_DCL = 'DCL';

    /**
     * Delivery information
     */
    const UNTDID_4451_DEL = 'DEL';

    /**
     * Delivery instructions
     */
    const UNTDID_4451_DIN = 'DIN';

    /**
     * Documentation instructions
     */
    const UNTDID_4451_DOC = 'DOC';

    /**
     * Duty declaration
     */
    const UNTDID_4451_DUT = 'DUT';

    /**
     * Effective used routing
     */
    const UNTDID_4451_EUR = 'EUR';

    /**
     * First block to be printed on the transport contract
     */
    const UNTDID_4451_FBC = 'FBC';

    /**
     * Government bill of lading information
     */
    const UNTDID_4451_GBL = 'GBL';

    /**
     * Entire transaction set
     */
    const UNTDID_4451_GEN = 'GEN';

    /**
     * Further information concerning GGVS par. 7
     */
    const UNTDID_4451_GS7 = 'GS7';

    /**
     * Consignment handling instruction
     */
    const UNTDID_4451_HAN = 'HAN';

    /**
     * Hazard information
     */
    const UNTDID_4451_HAZ = 'HAZ';

    /**
     * Consignment information for consignee
     */
    const UNTDID_4451_ICN = 'ICN';

    /**
     * Insurance instructions
     */
    const UNTDID_4451_IIN = 'IIN';

    /**
     * Invoice mailing instructions
     */
    const UNTDID_4451_IMI = 'IMI';

    /**
     * Commercial invoice item description
     */
    const UNTDID_4451_IND = 'IND';

    /**
     * Insurance information
     */
    const UNTDID_4451_INS = 'INS';

    /**
     * Invoice instruction
     */
    const UNTDID_4451_INV = 'INV';

    /**
     * Information for railway purpose
     */
    const UNTDID_4451_IRP = 'IRP';

    /**
     * Inland transport details
     */
    const UNTDID_4451_ITR = 'ITR';

    /**
     * Testing instructions
     */
    const UNTDID_4451_ITS = 'ITS';

    /**
     * Location Alias
     */
    const UNTDID_4451_LAN = 'LAN';

    /**
     * Line item
     */
    const UNTDID_4451_LIN = 'LIN';

    /**
     * Loading instruction
     */
    const UNTDID_4451_LOI = 'LOI';

    /**
     * Miscellaneous charge order
     */
    const UNTDID_4451_MCO = 'MCO';

    /**
     * Maritime Declaration of Health
     */
    const UNTDID_4451_MDH = 'MDH';

    /**
     * Additional marks/numbers information
     */
    const UNTDID_4451_MKS = 'MKS';

    /**
     * Order instruction
     */
    const UNTDID_4451_ORI = 'ORI';

    /**
     * Other service information
     */
    const UNTDID_4451_OSI = 'OSI';

    /**
     * Packing/marking information
     */
    const UNTDID_4451_PAC = 'PAC';

    /**
     * Payment instructions information
     */
    const UNTDID_4451_PAI = 'PAI';

    /**
     * Payables information
     */
    const UNTDID_4451_PAY = 'PAY';

    /**
     * Packaging information
     */
    const UNTDID_4451_PKG = 'PKG';

    /**
     * Packaging terms information
     */
    const UNTDID_4451_PKT = 'PKT';

    /**
     * Payment detail/remittance information
     */
    const UNTDID_4451_PMD = 'PMD';

    /**
     * Payment information
     */
    const UNTDID_4451_PMT = 'PMT';

    /**
     * Product information
     */
    const UNTDID_4451_PRD = 'PRD';

    /**
     * Price calculation formula
     */
    const UNTDID_4451_PRF = 'PRF';

    /**
     * Priority information
     */
    const UNTDID_4451_PRI = 'PRI';

    /**
     * Purchasing information
     */
    const UNTDID_4451_PUR = 'PUR';

    /**
     * Quarantine instructions
     */
    const UNTDID_4451_QIN = 'QIN';

    /**
     * Quality demands/requirements
     */
    const UNTDID_4451_QQD = 'QQD';

    /**
     * Quotation instruction/information
     */
    const UNTDID_4451_QUT = 'QUT';

    /**
     * Risk and handling information
     */
    const UNTDID_4451_RAH = 'RAH';

    /**
     * Regulatory information
     */
    const UNTDID_4451_REG = 'REG';

    /**
     * Return to origin information
     */
    const UNTDID_4451_RET = 'RET';

    /**
     * Receivables
     */
    const UNTDID_4451_REV = 'REV';

    /**
     * Consignment route
     */
    const UNTDID_4451_RQR = 'RQR';

    /**
     * Safety information
     */
    const UNTDID_4451_SAF = 'SAF';

    /**
     * Consignment documentary instruction
     */
    const UNTDID_4451_SIC = 'SIC';

    /**
     * Special instructions
     */
    const UNTDID_4451_SIN = 'SIN';

    /**
     * Ship line requested
     */
    const UNTDID_4451_SLR = 'SLR';

    /**
     * Special permission for transport, generally
     */
    const UNTDID_4451_SPA = 'SPA';

    /**
     * Special permission concerning the goods to be transported
     */
    const UNTDID_4451_SPG = 'SPG';

    /**
     * Special handling
     */
    const UNTDID_4451_SPH = 'SPH';

    /**
     * Special permission concerning package
     */
    const UNTDID_4451_SPP = 'SPP';

    /**
     * Special permission concerning transport means
     */
    const UNTDID_4451_SPT = 'SPT';

    /**
     * Subsidiary risk number (IATA/DGR)
     */
    const UNTDID_4451_SRN = 'SRN';

    /**
     * Special service request
     */
    const UNTDID_4451_SSR = 'SSR';

    /**
     * Supplier remarks
     */
    const UNTDID_4451_SUR = 'SUR';

    /**
     * Consignment tariff
     */
    const UNTDID_4451_TCA = 'TCA';

    /**
     * Consignment transport
     */
    const UNTDID_4451_TDT = 'TDT';

    /**
     * Transportation information
     */
    const UNTDID_4451_TRA = 'TRA';

    /**
     * Requested tariff
     */
    const UNTDID_4451_TRR = 'TRR';

    /**
     * Tax declaration
     */
    const UNTDID_4451_TXD = 'TXD';

    /**
     * Warehouse instruction/information
     */
    const UNTDID_4451_WHI = 'WHI';

    /**
     * Mutually defined
     */
    const UNTDID_4451_ZZZ = 'ZZZ';
}
