<?php
/**
 * WARNING: Do not edit by hand, this file was generated by Crank:
 *
 * https://github.com/gocardless/crank
 */

namespace GoCardlessPro\Services;

use \GoCardlessPro\Core\Paginator;
use \GoCardlessPro\Core\Util;
use \GoCardlessPro\Core\ListResponse;
use \GoCardlessPro\Resources\BankAuthorisation;
use \GoCardlessPro\Core\Exception\InvalidStateException;


/**
 * Service that provides access to the BankAuthorisation
 * endpoints of the API
 *
 * @method create()
 * @method get()
 */
class BankAuthorisationsService extends BaseService
{

    protected $envelope_key   = 'bank_authorisations';
    protected $resource_class = '\GoCardlessPro\Resources\BankAuthorisation';


    /**
     * Create a Bank Authorisation
     *
     * Example URL: /bank_authorisations
     *
     * @param  string[mixed] $params An associative array for any params
     * @return BankAuthorisation
     **/
    public function create($params = array())
    {
        $path = "/bank_authorisations";
        if(isset($params['params'])) { 
            $params['body'] = json_encode(array($this->envelope_key => (object)$params['params']));
        
            unset($params['params']);
        }

        
        try {
            $response = $this->api_client->post($path, $params);
        } catch(InvalidStateException $e) {
            if ($e->isIdempotentCreationConflict()) {
                if ($this->api_client->error_on_idempotency_conflict) {
                    throw $e;
                }
                return $this->get($e->getConflictingResourceId());
            }

            throw $e;
        }
        

        return $this->getResourceForResponse($response);
    }

    /**
     * Get a Bank Authorisation
     *
     * Example URL: /bank_authorisations/:identity
     *
     * @param  string        $identity Unique identifier, beginning with "BAU".
     * @param  string[mixed] $params   An associative array for any params
     * @return BankAuthorisation
     **/
    public function get($identity, $params = array())
    {
        $path = Util::subUrl(
            '/bank_authorisations/:identity',
            array(
                
                'identity' => $identity
            )
        );
        if(isset($params['params'])) { $params['query'] = $params['params'];
            unset($params['params']);
        }

        
        $response = $this->api_client->get($path, $params);
        

        return $this->getResourceForResponse($response);
    }

}
